    .text
    .global task_switch
    .global task_run_first
task_switch:
    // save r0-r12
    stmia r0, {r0-r12}
    
    // save to lr
    str lr, [r0, 4*13]
    
    // save sp
    str sp, [r0, 4*14]
    
    // save apsr
    mrs r2, apsr
    str r2, [r0, 4*15]
    
    // load sp
    ldr sp, [r1, 4*14]
    
    // load apsr
    ldr r2, [r1, 4*15]
    msr apsr, r2
    
    // load r0-r12
    ldmia r1, {r0-r12, pc}
    
task_run_first:
    // load sp
    ldr sp, [r0, 4*14]

    // load apsr
    ldr r2, [r0, 4*15]
    msr apsr, r2

    // load r0-r12
    ldmia r0, {r0-r12, pc}
