#include <stdio.h>
#include "ARMCM4.h"                     // Device header

int fputc(int ch, FILE *f) {
    ITM_SendChar(ch);
    return 0;
}

int func2 (void) {
    return 2;
}

int func1 (void) {
    int res = func2();
    return res;
}

struct task_context_t {
    unsigned int r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12; // 13 
    unsigned int return_addr;  // r14
    unsigned int stack_addr;   // r13
    unsigned int apsr;
};

void task_switch (struct task_context_t * from, struct task_context_t * to);
void task_run_first (struct task_context_t * to);

struct task_t {
    struct task_context_t context;
    unsigned int stack[80];
}task0, task1, task2;

void task_0_entry (void);
void task_1_entry (void);

void task_0_entry (void) {
    int count = 0;
    
    for (;;) {
        count++;
        printf("task0: %d\n", count);
        task_switch(&task0.context, &task1.context);
    }
}

void task_1_entry (void) {
    int count = 100;

    for (;;) {
        count++;
        printf("task1: %d\n", count);
        task_switch(&task1.context, &task2.context);
    }
}

void task_2_entry (void) {
    int count = 200;

    for (;;) {
        count++;
        printf("task2: %d\n", count);
        for (int i = 0; i < 0xFFFFF; i++) {}
        task_switch(&task2.context, &task0.context);
    }
}

void task_init (struct task_t * task, void (*entry)()) {
    task->context.r0 = 0x0;
    task->context.r1 = 0x1;
    task->context.r2 = 0x2;
    task->context.r3 = 0x3;
    task->context.r4 = 0x4;
    task->context.r5 = 0x5;
    task->context.r6 = 0x6;
    task->context.r7 = 0x7;
    task->context.r8 = 0x8;
    task->context.r9 = 0x9;
    task->context.r10 = 0x10;
    task->context.r11 = 0x11;
    task->context.r12 = 0x12;
    task->context.apsr = 1 << 31;
    task->context.return_addr = (unsigned int)entry;
    task->context.stack_addr = (unsigned int)(task->stack + 80);
}

int main (void) {
    task_init(&task0, task_0_entry);
    task_init(&task1, task_1_entry);
    task_init(&task2, task_2_entry);
    task_run_first(&task0.context);
    for (;;) {}
    return 0;
}
