
int func2 (void) {
    return 2;
}

int func1 (void) {
    int res = func2();
    return res;
}

struct task_context_t {
    unsigned int r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12; // 13
    unsigned int return_addr;  // r14
    unsigned int stack_addr;   // r13
    unsigned int apsr;
}task0, task1;

void task_switch (struct task_context_t * from, struct task_context_t * to);
void task_run_first (struct task_context_t * to);

void task_0_entry (void);
void task_1_entry (void);

void task_0_entry (void) {
    int count = -1;
    
    for (;;) {
        count++;
        task_switch(&task0, &task1);
    }
}

void task_1_entry (void) {
    int count = 0;

    for (;;) {
        count++;
        task_switch(&task1, &task0);
    }
}

unsigned int task0_stack[80];
unsigned int task1_stack[80];

int main (void) {
    task0.r0 = 0x0;
    task0.r1 = 0x1;
    task0.r2 = 0x2;
    task0.r3 = 0x3;
    task0.r4 = 0x4;
    task0.r5 = 0x5;
    task0.r6 = 0x6;
    task0.r7 = 0x7;
    task0.r8 = 0x8;
    task0.r9 = 0x9;
    task0.r10 = 0x10;
    task0.r11 = 0x11;
    task0.r12 = 0x12;
    task0.apsr = 1 << 31;
    task0.return_addr = (unsigned int)task_0_entry;
    task0.stack_addr = (unsigned int)&task0_stack[80];

    task1.return_addr = (unsigned int)task_1_entry;
    task1.stack_addr = (unsigned int)&task1_stack[80];
    task_run_first(&task0);
    for (;;) {}
    return 0;
}
